require "Dialogs"

Arena.Resize(360, 130)
timer = 0
tableaux = 0

state = 0
maxjump = 40
jump = 0
newpX = Player.absx
newpY = Player.absy

SetPPCollision(true)

Bones = {}
GBPaps = {}

function RecolorSoul()
	if state ~= 1 and state ~= 2 then
		Player.sprite.color = {1.0,0.0,0.0}
		Player.sprite.rotation = 0
	elseif state == 1 or state == 2 then
		Player.sprite.color = {0,60/255,1}
		Player.sprite.rotation = 0
	end
end

RecolorSoul()

function Update()
	DialogUpdate()
	timer = timer + 1
	if timer == 30 then
		Body = CreateProjectileAbs("Bullets/Bones/Body", 320 - Arena.width/2, 100)
		Body.SetVar("X", 320 - Arena.width/2)
		Body.SetVar("Y", 100)
		Body.SetVar("vel", 8)
		Body.SetVar("increase", 120/20/2)
		table.insert(Bones, Body)
		Body = CreateProjectileAbs("Bullets/Bones/Body", 320 + Arena.width/2, 220)
		Body.SetVar("X", 320 + Arena.width/2)
		Body.SetVar("Y", 220)
		Body.SetVar("vel", -8)
		Body.SetVar("increase", -120/20/2)
		table.insert(Bones, Body)
	elseif timer == 50 then
		state = 2
		maxjump = 52
		RecolorSoul()
		Audio.PlaySound("ding")
		Arena.Resize(150, 130)
	elseif timer == 130 then
		table.insert(GBPaps, {Sprite = CreateSprite("Bullets/GB Papyrus/0","BelowBullet"), Animacion = {DatosIniciales = {X = -38, Y = 530, rotation = 0}, DatosFinales = {X = 70, Y = 130, rotation = 90}}, Delay = 110, Duration = 40})
		table.insert(GBPaps, {Sprite = CreateSprite("Bullets/GB Papyrus/0","BelowBullet"), Animacion = {DatosIniciales = {X = 678, Y = 530, rotation = 0}, DatosFinales = {X = 570, Y = 130, rotation = -90}}, Delay = 110, Duration = 40})
		Audio.PlaySound("gasterintro")
		Audio.PlaySound("gasterintro2")
	elseif timer == 390 then
		if not Encounter["GameOver"] then
			if GetAlMightyGlobal("Idioma") == "Spanish" then
				Bubble("[noskip][font:papyrus][voice:papyrus]Me estás\nhaciendo difícil\nno lastimarte.", "rightwide", 490.5, 385, 40, 90, 1)
			elseif GetAlMightyGlobal("Idioma") == "Russian" then
				Bubble("[noskip][font:papyrus][voice:papyrus]Мне становится\nвсё сложнее не\nнавредить тебе.", "rightwide", 490.5, 385, 40, 90, 1)
			else
				Bubble("[noskip][font:papyrus][voice:papyrus]You're making\nit difficult\nfor me not\nto harm you.", "rightwide", 490.5, 385, 40, 90, 1)
			end
			dialogs = 1
		else
			Encounter["GameMusic"] = "Fade"
		end
	elseif timer >= 560 and Encounter["GameOver"] then
		EndWave()
	end
	if dialogs then
		if dialogs == 1 and Bubbles[1] and not Bubbles[1].Activo then
			if GetAlMightyGlobal("Idioma") == "Spanish" then
				Bubble("[noskip][font:papyrus][voice:papyrus]De verdad\nquieres que\neste sea tu\núltimo puzzle?", "rightwide", 490.5, 385, 40, 90, 1)
			elseif GetAlMightyGlobal("Idioma") == "Russian" then
				Bubble("[noskip][font:papyrus][voice:papyrus]Ты хочешь, чтобы\nэто была твоя\nпоследняя\nголоволомка?", "rightwide", 490.5, 385, 40, 90, 1)
			else
				Bubble("[noskip][font:papyrus][voice:papyrus]Do you really\nwant this to\nbe your last\npuzzle?", "rightwide", 490.5, 385, 40, 90, 1)
			end
			dialogs = 2
		elseif dialogs == 2 and Bubbles[1] and not Bubbles[1].Activo then
			EndWave()
		end
	end
	for i=1,#GBPaps do
		local gb = GBPaps[i - tableaux]
		if not gb.X then
			gb.X = gb.Sprite.x
		end
		if not gb.Y then
			gb.Y = gb.Sprite.y
		end
		gb.Sprite.xscale = (gb.Scale or 1)
		if gb.Animacion then
			if not gb.Animacion.timer then
				gb.Animacion.timer = 0
			end
			gb.Animacion.timer = gb.Animacion.timer + 1
			gb.X = gb.Animacion.DatosIniciales.X + (gb.Animacion.DatosFinales.X - gb.Animacion.DatosIniciales.X)*math.sin(math.rad(gb.Animacion.timer*(90/(gb.Animacion.VelAppearing or 30))))
			gb.Y = gb.Animacion.DatosIniciales.Y + (gb.Animacion.DatosFinales.Y - gb.Animacion.DatosIniciales.Y)*math.sin(math.rad(gb.Animacion.timer*(90/(gb.Animacion.VelAppearing or 30))))
			gb.Sprite.MoveTo(gb.X, gb.Y)
			while gb.Animacion.DatosIniciales.rotation >= 360 or gb.Animacion.DatosIniciales.rotation < 0 do
				if gb.Animacion.DatosIniciales.rotation < 0 then
					gb.Animacion.DatosIniciales.rotation = gb.Animacion.DatosIniciales.rotation + 360
				else
					gb.Animacion.DatosIniciales.rotation = gb.Animacion.DatosIniciales.rotation - 360
				end
			end
			while gb.Animacion.DatosFinales.rotation >= 360 or gb.Animacion.DatosFinales.rotation < 0 do
				if gb.Animacion.DatosFinales.rotation < 0 then
					gb.Animacion.DatosFinales.rotation = gb.Animacion.DatosFinales.rotation + 360
				else
					gb.Animacion.DatosFinales.rotation = gb.Animacion.DatosFinales.rotation - 360
				end
			end
			if gb.Animacion.DatosFinales.rotation - gb.Animacion.DatosIniciales.rotation <= 180 and gb.Animacion.DatosFinales.rotation - gb.Animacion.DatosIniciales.rotation >= -180 then
				gb.Sprite.rotation = gb.Animacion.DatosIniciales.rotation - (gb.Animacion.DatosIniciales.rotation - gb.Animacion.DatosFinales.rotation)*math.sin(math.rad(gb.Animacion.timer*(90/(gb.Animacion.VelAppearing or 30))))
			else
				gb.Sprite.rotation = gb.Animacion.DatosIniciales.rotation - (360 - (gb.Animacion.DatosFinales.rotation - 180 + gb.Animacion.DatosIniciales.rotation - 180)*math.sin(math.rad(gb.Animacion.timer*(90/(gb.Animacion.VelAppearing or 30)))))
			end
			if gb.Animacion.timer >= (gb.Animacion.VelAppearing or 30) then
				gb.Animacion = nil
				gb.Done = true
			end
		else
			if gb.Rotation and not gb.Done then
				gb.Sprite.rotation = gb.Rotation
			end
			gb.Delay = gb.Delay - 1
		end
		if gb.Vel then
			gb.X = gb.X - gb.Vel*math.sin(math.rad(gb.Sprite.rotation))
			gb.Y = gb.Y + gb.Vel*math.cos(math.rad(gb.Sprite.rotation))
			gb.Vel = gb.Vel*1.1
			if gb.X < -100 or gb.X > 740 or gb.Y < -100 or gb.Y > 580 then
				gb.Vel = 0
			end
		end
		gb.Sprite.MoveTo(gb.X, gb.Y)
		if gb.Delay < 0 then
			if gb.Delay == -1 then
				gb.Sprite.Set("Bullets/GB Papyrus/1")
				gb.Vel = 2
				Audio.PlaySound("gasterfire")
			elseif gb.Delay <= -2 then
				if gb.Delay == -3 then
					Misc.ShakeScreen(gb.Duration, 8, true)
				end
				if gb.Duration > 0 then
					gb.Duration = gb.Duration - 1
					if not gb.Laser then
						gb.Laser = {Misil = CreateProjectileAbs("Bullets/GB Laser", gb.X + (640 + 26*gb.Sprite.yscale)*math.sin(math.rad(gb.Sprite.rotation)), gb.Y - (640 + 26*gb.Sprite.yscale)*math.cos(math.rad(gb.Sprite.rotation)))}
						gb.Laser.Misil.sprite.xscale = 0
						gb.Laser.Misil.sprite.rotation = gb.Sprite.rotation
						gb.Laser.Scale = 0
					else
						gb.Laser.Misil.MoveToAbs(gb.X + (640 + 26*gb.Sprite.yscale)*math.sin(math.rad(gb.Sprite.rotation)), gb.Y - (640 + 26*gb.Sprite.yscale)*math.cos(math.rad(gb.Sprite.rotation)))
						if gb.Laser.Misil.sprite.xscale < 0.9*gb.Sprite.xscale and gb.Laser.Scale == 0 then
							gb.Laser.Misil.sprite.xscale = gb.Laser.Misil.sprite.xscale + 0.1*gb.Sprite.xscale
						else
							gb.Laser.Scale = gb.Laser.Scale + 50
							gb.Laser.Misil.sprite.xscale = 0.9*gb.Sprite.xscale + 0.1*gb.Sprite.xscale*math.sin(math.rad(gb.Laser.Scale))
						end
					end
				else
					gb.Laser.Misil.SetVar("No Damage", true)
					if gb.Laser.Misil.sprite.xscale > 0 then
						gb.Laser.Misil.MoveToAbs(gb.X + (640 + 26*gb.Sprite.yscale)*math.sin(math.rad(gb.Sprite.rotation)), gb.Y - (640 + 26*gb.Sprite.yscale)*math.cos(math.rad(gb.Sprite.rotation)))
						gb.Laser.Misil.sprite.xscale = gb.Laser.Misil.sprite.xscale - 0.05*gb.Sprite.xscale
						gb.Laser.Misil.sprite.alpha = gb.Laser.Misil.sprite.xscale
					else
						gb.Laser.Misil.Remove()
						gb.Sprite.Remove()
						gb = nil
						table.remove(GBPaps, i - tableaux)
						tableaux = tableaux + 1
					end
				end
			end
		end
	end
	tableaux = 0
	for i=1,#Bones do
		local bullet = Bones[i]
		if not bullet.GetVar("head") then
			bullet.SetVar("head", CreateProjectileAbs("Bullets/Bones/Head", bullet.GetVar("X"), bullet.GetVar("Y") + bullet.sprite.yscale/2 + 2.5))
		end
		if not bullet.GetVar("legs") then
			bullet.SetVar("legs", CreateProjectileAbs("Bullets/Bones/Head", bullet.GetVar("X"), bullet.GetVar("Y") - bullet.sprite.yscale/2 - 2.5))
			bullet.GetVar("legs").sprite.rotation = 180
		end
		if timer < 50 then
			bullet.sprite.yscale = bullet.sprite.yscale + 120/20
			bullet.MoveToAbs(bullet.GetVar("X") + bullet.GetVar("vel"), bullet.GetVar("Y") + bullet.GetVar("increase"))
			bullet.SetVar("X", bullet.GetVar("X") + bullet.GetVar("vel"))
			bullet.SetVar("Y", bullet.GetVar("Y") + bullet.GetVar("increase"))
			bullet.GetVar("head").MoveToAbs(bullet.GetVar("X"), bullet.GetVar("Y") + bullet.sprite.yscale/2 + 2.5)
			bullet.GetVar("legs").MoveToAbs(bullet.GetVar("X"), bullet.GetVar("Y") - bullet.sprite.yscale/2 - 2.5)
		elseif timer >= 70 and timer < 90 then
			bullet.sprite.color = {33/255, 197/255, 1}
			bullet.GetVar("head").sprite.color = {33/255, 197/255, 1}
			bullet.GetVar("legs").sprite.color = {33/255, 197/255, 1}
			bullet.SetVar("tipo", "Blue")
			bullet.GetVar("head").SetVar("tipo", "Blue")
			bullet.GetVar("legs").SetVar("tipo", "Blue")
			bullet.MoveToAbs(bullet.GetVar("X") + bullet.GetVar("vel")/4, bullet.GetVar("Y"))
			bullet.SetVar("X", bullet.GetVar("X") + bullet.GetVar("vel")/4)
			bullet.GetVar("head").MoveToAbs(bullet.GetVar("X"), bullet.GetVar("Y") + bullet.sprite.yscale/2 + 2.5)
			bullet.GetVar("legs").MoveToAbs(bullet.GetVar("X"), bullet.GetVar("Y") - bullet.sprite.yscale/2 - 2.5)
		elseif timer >= 100 and timer < 120 then
			bullet.sprite.rotation = bullet.sprite.rotation + 120/20/8*bullet.GetVar("vel")
			bullet.GetVar("head").sprite.rotation = bullet.sprite.rotation
			bullet.GetVar("legs").sprite.rotation = bullet.sprite.rotation + 180
			bullet.GetVar("head").MoveToAbs(bullet.GetVar("X") - (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") + (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
			bullet.GetVar("legs").MoveToAbs(bullet.GetVar("X") + (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") - (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
		elseif timer == 130 then
			bullet.sprite.color = {1, 1, 1}
			bullet.GetVar("head").sprite.color = {1, 1, 1}
			bullet.GetVar("legs").sprite.color = {1, 1, 1}
			bullet.SetVar("tipo", nil)
			bullet.GetVar("head").SetVar("tipo", nil)
			bullet.GetVar("legs").SetVar("tipo", nil)
		elseif timer >= 140 and timer < 180 then
			bullet.MoveToAbs(bullet.GetVar("X"), bullet.GetVar("Y") + 20*math.sin(math.rad(90/40*(timer - 139))))
			bullet.GetVar("head").MoveToAbs(bullet.GetVar("X") - (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") + 20*math.sin(math.rad(90/40*(timer - 139))) + (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
			bullet.GetVar("legs").MoveToAbs(bullet.GetVar("X") + (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") + 20*math.sin(math.rad(90/40*(timer - 139))) - (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
		elseif timer == 180 then
			bullet.SetVar("Y", bullet.GetVar("Y") + 20)
		elseif timer >= 190 and timer < 195 then
			bullet.sprite.rotation = bullet.sprite.rotation + 15/5/8*bullet.GetVar("vel")
			bullet.GetVar("head").MoveToAbs(bullet.GetVar("X") - (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") + (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
			bullet.GetVar("legs").MoveToAbs(bullet.GetVar("X") + (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") - (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
		elseif timer >= 200 and timer < 290 then
			bullet.sprite.rotation = bullet.sprite.rotation - 180/90/8*bullet.GetVar("vel")
			bullet.GetVar("head").sprite.rotation = bullet.sprite.rotation
			bullet.GetVar("legs").sprite.rotation = bullet.sprite.rotation + 180
			bullet.GetVar("head").MoveToAbs(bullet.GetVar("X") - (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") + (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
			bullet.GetVar("legs").MoveToAbs(bullet.GetVar("X") + (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") - (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
		elseif timer >= 300 then
			bullet.MoveToAbs(bullet.GetVar("X"), bullet.GetVar("Y") - 2.5)
			bullet.SetVar("Y", bullet.GetVar("Y") - 2.5)
			bullet.GetVar("head").MoveToAbs(bullet.GetVar("X") - (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") + (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
			bullet.GetVar("legs").MoveToAbs(bullet.GetVar("X") + (bullet.sprite.yscale/2 + 2.5)*math.sin(math.rad(bullet.sprite.rotation)), bullet.GetVar("Y") - (bullet.sprite.yscale/2 + 2.5)*math.cos(math.rad(bullet.sprite.rotation)))
		end
	end
	if state ~= 1 and state ~= 2 then
		if Input.Right > 0 then
			newpX = newpX + 2
		end
		if Input.Left > 0 then
			newpX = newpX - 2
		end
		if Input.Up > 0 then
			newpY = newpY + 2
		end
		if Input.Down > 0 then
			newpY = newpY - 2
		end
		if newpX < 328 - Arena.width/2 then
			newpX = 328 - Arena.width/2
		elseif newpX > 312 + Arena.width/2 then
			newpX = 312 + Arena.width/2
		end
		if newpY < 103 then
			newpY = 103
		elseif newpY > 87 + Arena.height then
			newpY = 87 + Arena.height
		end
		Player.MoveToAbs(newpX, newpY, true)
    end
    if state == 1 then -- Down
		if Input.Right > 0 then
			newpX = newpX + 3
		end
		if Input.Left > 0 then
			newpX = newpX - 3
		end
		if newpY < 105 then
			if Input.Up > 0 then
				jump = maxjump
			else
				newpY = 103
				jump = 0
			end
		elseif jump < 3 and jump > -3 then
			jump = jump - 0.33
		elseif jump < -3 and jump > -10 then
			jump = -10
		elseif jump < -3 then
			jump = jump - 1
		else
			jump = (jump/1.001) - 0.66
		end
		if Input.Up < 0 and jump > 2 then
			jump = 1.33
		end
		newpY = math.max(newpY + (jump/10), 103)
		if newpX < 328 - Arena.width/2 then
			newpX = 328 - Arena.width/2
		elseif newpX > 312 + Arena.width/2 then
			newpX = 312 + Arena.width/2
		end
		Player.MoveToAbs(newpX, newpY, true)
    end
    if state == 2 then -- Down
		if Input.Right > 0 then
			newpX = newpX + 3
		end
		if Input.Left > 0 then
			newpX = newpX - 3
		end
		if newpY < Arena.y + 15 then
			state = 1
			maxjump = 32
			if Input.Up > 0 then
				jump = maxjump
			else
				newpY = Arena.y + 13
				jump = 0
			end
		elseif jump < 3 and jump > -3 then
			jump = jump - 1
		elseif jump < -3 and jump > -10 then
			jump = -10
		elseif jump < -3 then
			jump = jump - 3
		else
			jump = (jump/1.001) - 2
		end
		if Input.Up < 0 and jump > 6 then
			jump = 4
		end
		newpY = math.max(newpY + (jump/10), 103)
		if newpX < 328 - Arena.width/2 then
			newpX = 328 - Arena.width/2
		elseif newpX > 312 + Arena.width/2 then
			newpX = 312 + Arena.width/2
		end
		Player.MoveToAbs(newpX, newpY, true)
    end
end

function OnHit(bullet)
	if not bullet.GetVar("No Damage") then
		if bullet.GetVar("tipo") then
			if bullet.GetVar("tipo") == "Blue" and (Input.Left > 0 or Input.Right > 0 or jump ~= 0) and not Player.isHurting then
				if Player.hp == 1 then
					Player.Hurt(0, 2)
					Encounter["GameOver"] = true
				end
				if Encounter["HPEnvenenadosPorKR"] == Player.hp - 1 and Player.hp > 1 and not Player.isHurting then
					Player.hp = Player.hp - 1
					Player.Hurt(0, 2/60)
				elseif Player.hp > 1 then
					Player.Hurt(0, 2/60)
					if Encounter["Glow"].alpha >= 0.9 then
						Encounter.Call("AddKR", 2)
					elseif Encounter["Glow"].alpha >= 0.6 then
						Encounter.Call("AddKR", 1.5)
					elseif Encounter["Glow"].alpha >= 0.3 then
						Encounter.Call("AddKR", 1)
					end
				end
				Encounter["NOHIT"] = nil
			elseif bullet.GetVar("tipo") == "Orange" and (Input.Left <= 0 and Input.Right <= 0 and jump == 0) and not Player.isHurting then
				if Player.hp == 1 then
					Player.Hurt(0, 2)
					Encounter["GameOver"] = true
				end
				if Encounter["HPEnvenenadosPorKR"] == Player.hp - 1 and Player.hp > 1 then
					Player.hp = Player.hp - 1
					Player.Hurt(0, 2/60)
				elseif Player.hp > 1 then
					Player.Hurt(0, 2/60)
					if Encounter["Glow"].alpha >= 0.9 then
						Encounter.Call("AddKR", 2)
					elseif Encounter["Glow"].alpha >= 0.6 then
						Encounter.Call("AddKR", 1.5)
					elseif Encounter["Glow"].alpha >= 0.3 then
						Encounter.Call("AddKR", 1)
					end
				end
				Encounter["NOHIT"] = nil
			end
		elseif not Player.isHurting then
			if Player.hp == 1 then
				Player.Hurt(0, 2)
				Encounter["GameOver"] = true
			end
			if Encounter["HPEnvenenadosPorKR"] == Player.hp - 1 and Player.hp > 1 then
				Player.hp = Player.hp - 1
				Player.Hurt(0, 2/60)
			elseif Player.hp > 1 then
				Player.Hurt(0, 2/60)
				if Encounter["Glow"].alpha >= 0.9 then
					Encounter.Call("AddKR", 2)
				elseif Encounter["Glow"].alpha >= 0.6 then
					Encounter.Call("AddKR", 1.5)
				elseif Encounter["Glow"].alpha >= 0.3 then
					Encounter.Call("AddKR", 1)
				end
			end
			Encounter["NOHIT"] = nil
		end
	end
end